﻿using System;
using System.ServiceProcess;
using System.ComponentModel;
using System.Configuration.Install;
using VBECS.Services.Common.AppServices;
using VBECS.Services.Common;

namespace VBECS.Service
{
    /// <summary>
    /// Service installer class
    /// </summary>
    [RunInstaller(true)]
    public class WindowsServiceInstaller : Installer
    {
        #region Constructors

        /// <summary>
        /// Instance constructor
        /// </summary>
        /// <exception cref="ArgumentException"></exception>
        public WindowsServiceInstaller()
        {
            ServiceProperties serviceProperties = GlobalContext.Instance().ServiceProperties;

            var userName = GlobalContext.Instance().ServiceProperties.AccountName;
            var userPass = GlobalContext.Instance().ServiceProperties.AccountPValue;
            //Check if there is user/pass account information is available in the configuration file
            if (userName != null && userPass == null ||
                userName == null && userPass != null)
            {
                throw new ArgumentException("Both user and pass parameters need to be specified in configuration file.");
            }
            if (userName != null)
            {
                _processInstaller.Account = ServiceAccount.User;
                _processInstaller.Username = userName;
                _processInstaller.Password = userPass;
            }
            else
            {
                _processInstaller.Account = ServiceAccount.LocalSystem;
            }

            _serviceInstaller.ServiceName = serviceProperties.Name;
            _serviceInstaller.Description = serviceProperties.Description;
            _serviceInstaller.DisplayName = _serviceInstaller.ServiceName;
            _serviceInstaller.StartType = ServiceStartMode.Automatic;

            var installer = new Installer[] { _processInstaller, _serviceInstaller };

            Installers.AddRange(installer);
        }

        #endregion

        #region Fields

        private readonly ServiceProcessInstaller _processInstaller = new ServiceProcessInstaller();
        private readonly ServiceInstaller _serviceInstaller = new ServiceInstaller();

        #endregion

    }

}
